package fr.upem.jacosa.collections;

// @run: PointTester

class Point
{
	private final int x;
	private final int y;
	
	public Point(int x, int y)
	{
		this.x = x;
		this.y = y;
	}
	
	public int getX() { return x; }
	public int getY() { return y; }
	
	@Override
	public boolean equals(Object o)
	{
		if (o == null) return false;
		if (this == o) return true;
		if (! (o instanceof Point)) return false;
		Point p = (Point)o;
		return x == p.x && y == p.y;
	}
}

class GrayColoredPoint extends Point
{
	private final int grayLevel;
	
	public GrayColoredPoint(int x, int y, int grayLevel) 
	{
		super(x, y);
		this.grayLevel = grayLevel;
	}
	
	@Override
	public boolean equals(Object o)
	{
		if (o == null) return false;
		if (this == o) return true;
		if (! (o instanceof GrayColoredPoint)) return false;
		GrayColoredPoint p = (GrayColoredPoint)o;
		return getX() == p.getX() && getY() == p.getY() && grayLevel == p.grayLevel;
	}
}

public class PointTester
{
	public static void main(String[] args)
	{
		Point p = new Point(0, 0);
		GrayColoredPoint gcp = new GrayColoredPoint(0, 0, 128);
		System.out.println(p.equals(gcp)); // true
		System.out.println(gcp.equals(p)); // false: symmetry not respected!
	}
}