package fr.upem.jacosa.collections;

import java.util.Map;
import java.util.TreeMap;


public class ContactBook
{
	/*private Map<String, String> phoneMap;
	private Map<String, String> emailMap;*/
	
	/** Map linking the name to the contact */
	private Map<String, Contact> contactMap;
	
	public static class Contact
	{
		private String name;
		private String phone;
		private String email;
		
		public Contact(String name, String phone, String email)
		{
			this.name = name;
			this.phone = phone;
			this.email = email;
		}
		
		public String getName() { return name; }
		public String getPhone() { return phone; }
		public String getEmail() { return email; }
		
		public String toString()
		{
			return name + "," + phone + "," + email;
		}
	}
	
	/** Add a person in the contact book */
	public void addPerson(String name, String phone, String email)
	{
		/*phoneMap.put(name, phone);
		emailMap.put(name, email);*/
		Contact oldContact = contactMap.put(name, new Contact(name, phone, email));
		System.err.println("oldContact: " + oldContact);
	}
	
	/** Get the contact object linked to the name */
	public Contact getContact(String name)
	{
		return contactMap.get(name);
	}
	
	public ContactBook()
	{
		contactMap = new TreeMap<>();
	}
	
	public static void main(String[] args)
	{
		ContactBook cb = new ContactBook();
		cb.addPerson("toto", "123456", "toto@example.com");
		cb.addPerson("toto", "145", "toto2@example.com");
		cb.addPerson("tutu", "3000", "tutu@example.com");
		System.out.println(cb.getContact("toto"));
		System.out.println(cb.getContact("tutu"));
		System.out.println(cb.contactMap);
		System.out.println(cb.contactMap.keySet());
		System.out.println(cb.contactMap.values());
		System.out.println(cb.contactMap.entrySet());
	}
}
