package fr.upem.jacosa.collections;

import java.util.Objects;

// @run: BinaryTree

public class BinaryTree<T>
{
	private T value;
	private BinaryTree<T> child1, child2;
	
	public BinaryTree(T value, BinaryTree<T> child1, BinaryTree<T> child2)
	{
		this.value = value;
		this.child1 = child1;
		this.child2 = child2;
	}
	
	@Override
	public boolean equals(Object o)
	{
		if (o == null) return false;
		if (this == o) return true;
		if (! (o.getClass().equals(this.getClass()))) return false;
		@SuppressWarnings("unchecked")
		BinaryTree<T> o2 = (BinaryTree<T>)o;
		return Objects.equals(child1, o2.child1)
			&& Objects.equals(child2, o2.child2)
			&& Objects.equals(value, o2.value);
	}
	
	public static void main(String[] args) 
	{
		BinaryTree<Integer> bt1 = new BinaryTree<Integer>(0, new BinaryTree<Integer>(1, null, null), null);
		BinaryTree<Integer> bt2 = new BinaryTree<Integer>(0, new BinaryTree<Integer>(1, null, null), null);
		System.out.println(bt1.equals(bt2));
		bt1.child1 = bt1;
		bt2.child1 = bt2;
		System.out.println(bt1.equals(bt2)); // StackOverflowException !
	}
}
