package fr.upem.jacosa.collections;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/** Implementation of an iterator for the Bag */
public class BagIterator<E> implements Iterator<E>
{
	private Iterator<Map.Entry<E, Integer>> entryIterator;
	private E element = null;
	private int sampleNumber = 0;
	
	private void takeNext()
	{
		Map.Entry<E, Integer> entry = entryIterator.next();
		element = entry.getKey();
		sampleNumber = entry.getValue();
	}
	
	public BagIterator(Bag<E> bag)
	{
		entryIterator = bag.content.entrySet().iterator();
		if (entryIterator.hasNext())
		{
			takeNext();
		}
	}
	
	/** Is there a next element in the bag? */
	@Override
	public boolean hasNext()
	{
		return sampleNumber > 0;
	}

	/** Retrieve the next element in the bag */
	@Override
	public E next()
	{
		if (hasNext())
		{
			E currentElement = element;
			sampleNumber--;
			if (sampleNumber == 0 && entryIterator.hasNext())
			{
				takeNext();
			}
			return currentElement;
		} else
			throw new NoSuchElementException();
	}

}
