package fr.upem.jacosa.collections;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Bag<T> implements Iterable<T>
{
	Map<T, Integer> content;
	
	public Bag()
	{
		this.content = new TreeMap<T, Integer>();
	}
	
	/** Get the current number of samples of an element */
	public int get(T element)
	{
		Integer samples = content.get(element);
		return (samples == null)?0:samples;
	}
	
	/** Add a new sample of the element and return the current number of samples in the bag */
	public int add(T element)
	{
		int newSamples = get(element) + 1;
		content.put(element, newSamples);
		return newSamples;
	}
	
	/** Remove a sample of the element and return the remaining number of samples */
	public int remove(T element)
	{
		int newSamples = get(element) - 1;
		switch (newSamples)
		{
			case -1: break; // nothing to do, the element was not present
			case 0: content.remove(element); break; // no more samples
			default: content.put(element, newSamples);
		}
		return Math.max(0, newSamples);
	}
	
	@Override
	public String toString()
	{
		StringBuilder sb = new StringBuilder("[");
		boolean first = true;
		for (Map.Entry<T, Integer> entry: content.entrySet())
		{
			if (! first) sb.append(",");
			sb.append(entry.getKey() + "=" + entry.getValue());
			first = false;
		}
		sb.append("]");
		return sb.toString();
	}
	
	@Override
	public Iterator<T> iterator()
	{
		return new BagIterator<T>(this);
	}
	
	public static void main(String[] args)
	{
		Bag<String> bag = new Bag<>();
		bag.add("pomme");
		bag.add("citron");
		bag.add("mangue");
		bag.add("fraise");
		bag.add("poire");
		bag.add("citron");
		System.out.println(bag);
		bag.remove("poire");
		System.out.println(bag);
		for (String e: bag)
			System.out.println(e);
	}
}