package fr.upem.jacosa.areacomputation;


import java.util.function.Predicate;

/** Experimental computation of the area of a shape */
public class AreaComputer {

	private final double squareSide;
	private final Predicate<Point> shape;
	
	public AreaComputer(double squareSide, Predicate<Point> shape)
	{
		this.squareSide = squareSide;
		this.shape = shape;
	}

	/** Estimate the surface of the shape by making experimental throws */
	public double estimateSurface(final int throwNumber)
	{
		int throwInside = 0;
		for (int i = 0; i < throwNumber; i++)
		{
			Point p = Point.createRandomPoint(squareSide);
			if (shape.test(p)) throwInside++;
		}
		double insideRatio = (double)throwInside / throwNumber; // don't forget to cast
		return squareSide * squareSide * insideRatio;
	}
}
