package fr.upem.jacosa.annotations;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;

/** Module to configure the injection for the customer */
public class MyInjectionModule extends AbstractModule
{
	@Override
	protected void configure()
	{
		bind(Customer.class).to(Customer.class);
		bind(ShoppingBasket.class).to(ShoppingBasketImpl.class);
		bind(String.class).annotatedWith(Names.named("customerName")).toInstance("Santa Claus");
		bind(String.class).annotatedWith(Names.named("customerAddress")).toInstance("Laponia");
	}

}
