package fr.upem.zoo;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;

import javax.enterprise.context.RequestScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ManagedBean(name="internationalizedPageLoader")
@RequestScoped
public class InternationalizedPageLoader 
{
	public String getResource(String path, Locale l) throws IOException
	{
		ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
		for (String suffix: new String[]{l.getLanguage() + "_" + l.getCountry(), l.getLanguage()})
		{
			String newPath = path.replace(".xhtml", String.format(".%s.xhtml", suffix));
			URL url = context.getResource(newPath);
			if (url != null)
				return newPath;
		}
		return null;
	}
	
	public void loadPage() throws IOException
	{
		FacesContext context = FacesContext.getCurrentInstance();
		ExternalContext external = context.getExternalContext();
		Iterator<Locale> it = context.getExternalContext().getRequestLocales();
		String path = context.getViewRoot().getViewId();
		while (it.hasNext())
		{
			String newPath = getResource(path, it.next());
			if (newPath != null)
			{
				external.redirect(external.getRequestContextPath() + newPath);
				return;
			}
		}
		String newPath = getResource(path, Locale.ENGLISH);
		if (newPath != null)
			external.redirect(external.getRequestContextPath() + newPath);
		else
			external.setResponseStatus(HttpServletResponse.SC_NOT_FOUND);
	}
}
