package fr.upem.zoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;

@RequestScoped
@Named("guestbookBean")
public class GuestbookBean 
{
	@ConversationScoped
	public static class Message implements Serializable
	{
		private static final long serialVersionUID = 1L;
		
		private String name;
		private String email;
		private String body;
		
		public String getName() { return name; }
		public void setName(String name) { this.name = name; }
		
		public String getEmail() { return email; }
		public void setEmail(String email) { this.email = email; }
		
		public String getBody() { return body; }
		public void setBody(String body) { this.body = body; }
	}
	
	@ApplicationScoped
	public static class Guestbook
	{
		private List<Message> messages = new ArrayList<>();
		
		public List<Message> getMessageList() { return messages; }
	}
	
	@Inject private Message message;
	
	@Inject private Guestbook guestbook;
	
	public Message getMessage()
	{
		return message;
	}
	
	public Guestbook getGuestbook()
	{
		return guestbook;
	}
	
	public String submit()
	{
		guestbook.getMessageList().add(message);
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Message added", 
        	"Your message was successfully added in the guestbook, the guestbook contains now " + getGuestbook().getMessageList().size() + " messages")); 
        return null;
	}
}
