package fr.upem.jacosa.threads;

import java.util.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.regex.*;

public class Grep
{
	final private List<File> files;
	final private Pattern pattern;
	final private ExecutorService executorService;

	public Grep(File directory, Pattern pattern, ExecutorService executorService)
	{
		this.files = new ArrayList<File>();
		getFiles(directory, files);
		this.pattern = pattern;
		this.executorService = executorService;
	}

	public static void getFiles(File file, List<File> files)
	{
		if (file.isDirectory())
			for (File f: file.listFiles())
				getFiles(f, files);
		else if (file.isFile())
			files.add(file);
	}

	public Callable<List<MatchResult>> getGrepTask(final File f)
	{
		return new Callable<List<MatchResult>>()
		{
			public List<MatchResult> call() throws IOException
			{
				StringBuilder sb = new StringBuilder();
				Reader r = new FileReader(f);
				char[] buffer = new char[1024];
				int read = 0;
				while ((read = r.read(buffer)) > 0)
					sb.append(buffer, 0, read); // Append in the buffer
				Matcher m = pattern.matcher(sb.toString());
				List<MatchResult> result = new ArrayList<MatchResult>();
				while (m.find()) result.add(m.toMatchResult());
				return result;
			}
		};
	}

	public static <K> void increment(Map<K,Integer> map, K element)
	{
		Integer c = map.get(element);
		int c2 = (c == null)?0:c;
		map.put(element, c2 + 1);
	}

	public void execute() throws Exception
	{
		List<Future<List<MatchResult>>> results = new ArrayList<Future<List<MatchResult>>>();
		for (File file: files)
			results.add(executorService.submit(getGrepTask(file)));
		executorService.shutdown();
		long start = System.nanoTime();
		while (! executorService.awaitTermination(1L, TimeUnit.SECONDS))
			System.out.println((System.nanoTime() - start) + " ns elapsed");
		SortedMap<String, Integer> counterMap = new TreeMap<String, Integer>();
		for (Future<List<MatchResult>> result: results)
			for (MatchResult mr: result.get())
				increment(counterMap, mr.group(0));
		for (Map.Entry<String, Integer> entry: counterMap.entrySet())
			System.out.println(entry.getKey() + "\t" + entry.getValue());
	}

	public static void main(String[] args) throws Exception
	{
		Pattern pattern = Pattern.compile(args[0]);
		File rootFile = new File(args[1]);
		ExecutorService exs = null;
		String kind = args[2];
		if (kind.equals("cached"))
			exs = Executors.newCachedThreadPool();
		else
			exs = Executors.newFixedThreadPool(Integer.parseInt(kind));
		new Grep(rootFile, pattern, exs).execute();
	}
}
