package fr.upem.jacosa.threads;

import java.util.concurrent.*;
import java.util.concurrent.atomic.*;

public class Countdown
{
	public static void main(String[] args) throws InterruptedException
	{
		final long start = System.nanoTime();
		final ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
		int i = 0;
		final AtomicInteger counter = new AtomicInteger(0);
		for (String arg: args)
		{
			final int id = i++;
			final int deadline = Integer.parseInt(arg); // in seconds
			final ScheduledFuture<?> future = ses.scheduleAtFixedRate(new Runnable()
			{
				public void run()
				{
					System.out.println(
						String.format("Remaining time for timer #%d: %d s.", id, 
							deadline - (System.nanoTime() - start) / 1000000000));
				}
			}, 0, 1, TimeUnit.SECONDS);
			counter.incrementAndGet();
			ses.schedule(new Callable<Object>()
			{
				public Object call()
				{
					System.out.println(
						String.format("End of timer #%d after %d seconds (late offset: %d ns.)", id, 
							deadline, System.nanoTime() - start - deadline * 1000000000L ));
					future.cancel(true);
					if (counter.decrementAndGet() == 0) ses.shutdown(); // End of executor service
					return null;
				}
			}, deadline, TimeUnit.SECONDS);
		}
		ses.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS); // We wait for the end of execution
	}
}
