package fr.upem.jacosa.serialization;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesReader
{
	// Tutorial : 
	// https://docs.oracle.com/javase/tutorial/essential/environment/properties.html
	public static Map<String, String> readProperties(String filepath) throws IOException
	{
		Properties p = new Properties();
		FileInputStream in = new FileInputStream(filepath);
		p.load(in);
		in.close();
		Map<String, String> map = new HashMap<String, String>();
		for (Object key: p.keySet())
			map.put(key.toString(), p.getProperty(key.toString()));
		return map;
	}
}