package fr.upem.jacosa.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

import java.util.Map;

public class JacksonBook {
    record Book(String title, int price) {}

    public static void main(String[] args) throws JsonProcessingException {
        var jsonMapper = new ObjectMapper();
        var yamlMapper = new ObjectMapper(new YAMLFactory());

        // try to jsonify a book and reload it
        Book b1 = new Book("Jackson's test", 1000);
        String b1json = jsonMapper.writeValueAsString(b1);
        System.out.println(b1json);
        Book b1reloaded = jsonMapper.readValue(b1json, Book.class); // specifying the class is compulsory
        System.out.println("Are b1 and b1reloaded the same? " + b1.equals(b1reloaded));
        System.out.println(yamlMapper.writeValueAsString(b1));

        // work now with a map of books
        var bookMap = Map.of("Useful book", b1,
                "Interesting book", new Book("The Art of Computer Programming", 2000),
                "Useless book", new Book("The book of vacuum", 0));
        String bookMapJson = jsonMapper.writeValueAsString(bookMap);
        String bookMapYaml = yamlMapper.writeValueAsString(bookMap);
        System.out.println("JSON:\n" + bookMapJson);
        System.out.println("YAML:\n" + bookMapYaml);
        var bookMapJsonReloaded = jsonMapper.readValue(bookMapJson, new TypeReference<Map<String, Book>>() {});
        var bookMapYamlReloaded = yamlMapper.readValue(bookMapYaml, new TypeReference<Map<String, Book>>() {});
        System.out.println("Are bookMap and bookMapJsonReloaded the same? " + bookMap.equals(bookMapJsonReloaded));
        System.out.println("Are bookMap and bookMapYamlReloaded the same? " + bookMap.equals(bookMapYamlReloaded));
    }
}
