package fr.upem.jacosa.serialization;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;

public class BookSerialization
{
	public static class Book implements Serializable
	{
		private final String title;
		private final int price;
		
		public Book(String title, int price)
		{
			this.title = title;
			this.price = price;
		}
	}
	
	public static void main(String[] args) throws IOException
	{
		String file = args[0];
		List<Book> l = new ArrayList<Book>();
		l.add(new Book("Hamlet", 10));
		Book b = new Book("Othello", 5);
		l.add(b);
		l.add(b);
		try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(Paths.get(file))))
		{
			oos.writeObject(l);
		}
	}
}
