package fr.upem.jacosa.safety;

import java.util.Iterator;
import java.util.List;

public class DuplicateRemover
{
	/** 
	 * Determine if a list is sorted (and does not contain null references)
	 * @param list the list to check
	 * @return if the list is sorted according to the default comparator
	 */
	public static <T extends Comparable<T>> boolean isSorted(List<T> list)
	{
		T previous = null;
		for (T element: list)
			if (element == null || (previous != null && previous.compareTo(element) > 0))
				return false;
			else
				previous = element;
		return true;
	}
	
	/**
	 * Get the number of duplicates in a sorted list (without null references)
	 * @param list the sorted list
	 * @return the number of duplicates
	 */
	public static <T extends Comparable<T>> int getDuplicateNumber(List<T> list)
	{
		assert(isSorted(list));
		T previous = null;
		int duplicates = 0;
		for (T element: list)
			if (previous != null && previous.equals(element))
				duplicates++;
			else
				previous = element;
		return duplicates;
	}
	
	/**
	 * Remove the duplicates from a sorted list
	 * @param list the sorted list (without null references)
	 */
	public static <T extends Comparable<T>> void removeDuplicates(List<T> list)
	{
		assert(isSorted(list)):"The list is not sorted (or contain null references)";
		int initialSize = list.size();
		T previous = null;
		int duplicates = 0;
		for (Iterator<T> it = list.iterator(); it.hasNext(); )
		{
			T element = it.next();
			if (previous != null && element.equals(previous))
			{
				it.remove();
				duplicates++;
			}
			else
				previous = element;
			assert(initialSize == list.size() + duplicates);
		}
		assert(getDuplicateNumber(list) == 0);
	}
}