import java.util.*; import java.io.*; import java.net.*;

public class TimeSender implements AutoCloseable
{
	private final DatagramSocket socket;
	private final DatagramPacket packet;

	public TimeSender(int port) throws SocketException
	{
		this.socket = new DatagramSocket();
		this.packet = new DatagramPacket(new byte[0], 0); // Packet with empty array
		this.packet.setPort(port);
	}

	public void sendTimePacket(InetAddress a) throws IOException
	{
		// We reuse the same datagram packet but modify its content and addressee
		byte[] timeData = new Date().toString().getBytes();
		packet.setData(timeData);
		packet.setAddress(a);
		// this.packet.setPort is useless since the port does not change
		socket.send(packet); // May throw an IOException
	}

	public static InetAddress getSuccessor(InetAddress a)
	{
		// Exercise: write the implementation of getSuccessor(InetAddress) returning the successor of an IP address.
		// Example: the successor of 10.1.2.3 is 10.1.2.4 (for last byte 0 and 255 are forbidden)
		return null; // TODO: to be written
	}
	
	public void close() throws IOException
	{
		socket.close();
	}

	public static void main(String[] args) throws IOException
	{
		if (args.length < 3) throw new IllegalArgumentException("Not enough arguments");
		InetAddress firstA = InetAddress.getByName(args[0]); // Start address
		InetAddress lastA = InetAddress.getByName(args[1]); // Stop address
		int port = Integer.parseInt(args[2]);
		try (TimeSender ts = new TimeSender(port))
		{
			for (InetAddress currentA = firstA; ! currentA.equals(lastA); currentA = getSuccessor(currentA))
				ts.sendTimePacket(currentA);
		}
	}
}
			
		
	

	
