import java.util.*;
import java.io.*;

/**
 * A nice class that finds the minimal byte from a file
 */
public class MinByteGetter
{
	public static final int BUFFER_LENGTH = 1024;
	
	private InputStream is;
	private byte[] buffer = new byte[BUFFER_LENGTH];
	
	public MinByteGetter(InputStream is)
	{
		this.is = is;
	}
	
	/** Get the minimal byte from the next chunk of the file */
	public int getPartialMinByte() throws IOException
	{
		int r = is.read(buffer);
		if (r < 0) return -1; // No more data to read in the file
		while (r < buffer.length)
		{
			 int k = is.read(buffer, r, buffer.length - r);
			 if (k < 0) break;
			 else r += k;
		}
		return findBufferMinByte(0, r);
	}
	
	/** Find the minimal byte in the buffer */
	public int findBufferMinByte(int offset, int length)
	{
		int minByte = 1 << 8; // Impossible value
		for (int i = offset; i < offset + length; i++)
			minByte = Math.min(minByte, (int)buffer[i] & 0xff);
		System.err.println("Partial minimum: " + minByte);
		return minByte;
	}
	
	/** Get the minimal byte in the file */
	public int getMinByte() throws IOException
	{
		int minByte = 1 << 8;
		byte[] buffer = new byte[BUFFER_LENGTH];
		for (int k = getPartialMinByte(); k >= 0; k = getPartialMinByte())
			minByte = Math.min(minByte, k);
		return minByte;
	}
	
	public static void main(String[] args) throws IOException
	{
		try (InputStream is = new FileInputStream(args[0]))
		{
			MinByteGetter getter = new MinByteGetter(is);
			// If the file is empty, it will print 256
			System.out.println("Minimal byte: " + getter.getMinByte());
		}
	}
}
