package fr.upem.jacosa.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpServer
{
	public static void main(String[] args) throws IOException
	{
		int port = Integer.parseInt(args[0]);
		final File directory = new File(args[0]);
		ServerSocket ss = new ServerSocket(port);
		ExecutorService es = Executors.newCachedThreadPool();
		while (! Thread.interrupted())
		{
			final Socket s = ss.accept();
			es.submit(new Runnable() {
				@Override public void run()
				{
					try {
						try (BufferedReader r = new BufferedReader(new InputStreamReader(s.getInputStream(), "ASCII"))) {
							String[] header = r.readLine().split(" ");
							s.shutdownInput(); // Discard the remaining lines
							int errorCode = 405;
							File f = null;
							if (header[0].equals("GET")) {
								f = new File(directory, header[1].substring(1));
								errorCode = f.exists() ? 200 : 404;
							}
							s.getOutputStream().write(("HTTP/1.0 " + errorCode
									+ " nomessage\r\nContent-Type: application/octet-stream\r\n\r\n").getBytes("ASCII"));
							switch (errorCode) {
								case 200:
									try (FileInputStream fis = new FileInputStream(f)) {
										fis.transferTo(s.getOutputStream());
									}
									break;
								default:
									s.getOutputStream().write("An error was encountered".getBytes("ASCII"));
									break;
							}
							s.getOutputStream().flush();
							s.close();
						}
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			});
		}
		es.shutdown();
	}
}
