package fr.upem.jacosa.net;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

import static fr.upem.jacosa.io.FileCopier1.transfer;

public class FileReceiverServer
{
	// After one minute with no new-connection, the server stops
	public static final int ACCEPT_TIMEOUT = 60000;

	private final File directory;
	private final int port;
	
	public FileReceiverServer(File directory, int port)
	{
		this.directory = directory;
		this.port = port;
	}

	public void launch() throws IOException
	{
		try (ServerSocket ss = new ServerSocket(port))
		{
			ss.setSoTimeout(ACCEPT_TIMEOUT);
			while (true)
			{
				try (Socket s = ss.accept();
					OutputStream os = new BufferedOutputStream(new FileOutputStream(
						new File(directory, s.getInetAddress() + "_" + s.getPort()))) )
				{
					// Save the data in a file named with the address and port of the client
					transfer(s.getInputStream(), os);
				} catch (SocketTimeoutException e)
				{
					System.err.println("The server will shutdown because no new connections are available");
					break;
				} catch (IOException e)
				{
					e.printStackTrace();
					continue; // Treat the next incoming client
				}
			}
		}
	}
		
	public static void main(String[] args) throws IOException
	{
		new FileReceiverServer(
			new File(args[0]), Integer.parseInt(args[1])).launch();
	}
}
