package fr.upem.jacosa.io;
import java.util.*;
import java.io.*;

public class WordLister2
{
	public static void main(String[] args) throws IOException
	{
		Scanner s = new Scanner(System.in);
		s.useDelimiter("[\\p{Punct}\\p{Space}]+");
		Map<String, Integer> occurrences = new TreeMap<>();
		int occurCounter = 0;
		while (s.hasNext())
		{
			String word = s.next();
			Integer i = occurrences.get(word);
			if (i == null) i = 0;
			occurrences.put(word, i+1);
			occurCounter++;
		}
		ArrayList<String> al = new ArrayList<>();
		for (Map.Entry<String, Integer> entry: occurrences.entrySet()) {
			System.out.println(entry.getKey() + ": " + entry.getValue());
			al.add(entry.getKey());
		}
        s.close();
        System.out.println("Total number of occurrences: " + occurCounter++);
        System.out.println("Size of the map: " + occurrences.size());
        
        al.sort( (a, b) -> {
			int occurA = occurrences.get(a);
			int occurB = occurrences.get(b);
			if (occurA > occurB) return -1;
			else if (occurA < occurB) return 1;
			else return a.compareTo(b);
		});
		System.out.println(al);
	}
}
