package fr.upem.jacosa.io;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathHandling 
{
	public static void main(String[] args)
	{
		// we assume that the JVM is run from the working directory /home/user
		Path path1 = Paths.get("foo", "bar");
		System.out.println("path1=" + path1); // should print the relative path "foo/bar"
		System.out.println("absolute path of path1=" + path1.toAbsolutePath()); // should print the absolute path "/home/user/foo/bar"
		Path path2 = Paths.get("xyz");
		Path path3 = path1.resolve(path2); // path3 is foo/bar/xyz
		System.out.println("path3=" + path3); // should print "foo/bar/xyz"
		System.out.println("parent of path3=" + path3.getParent()); // should print "/foo/bar"
		System.out.println("path3.equals(path1)? " + path3.getParent().equals(path1)); // should be true
		Path path4 = path1.relativize(path3);
		System.out.println("path4=" + path4);
		System.out.println("path4.equals(path2)? " + path4.equals(path2)); // should be true
		
		// what is the filesystem used for the path?
		System.out.println("filesystem of path1=" + path1.getFileSystem());
	}
}
