package fr.upem.jacosa.io;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.SortedSet;
import java.util.TreeSet;

// @run: FileLister

/** List all the files of a directory (sorted by name and modification date) */
public class FileLister
{
	public static void main(String[] args) throws IOException
	{
		if (args.length < 1)
		{
			System.err.println("No argument specified");
			System.exit(-1);
		}
		final Path dir = Paths.get(args[0]);
		if (! Files.exists(dir) || ! Files.isDirectory(dir))
		{
			System.err.println(dir + " does not exist or is not a directory");
			System.exit(-1);
		}
		
		// we add the files into a SortedSet (the natural ordering on files is based on the lexicographic order of their names)
		SortedSet<Path> sortedFiles = new TreeSet<>() ;
		for (Path p: Files.newDirectoryStream(dir)) sortedFiles.add(p) ;
		
		// we use an other SortedSet with an explicit order based on the modification date of the file
		SortedSet<Path> sortedFiles2 = new TreeSet<>( (p1, p2) -> { 
			try {
				return Files.getLastModifiedTime(p1).compareTo(Files.getLastModifiedTime(p2));
			} catch (IOException e)
			{
				return 0;
			}}
		);
			
		for (Path p: Files.newDirectoryStream(dir)) sortedFiles2.add(p) ;

		System.out.println("Files sorted by name: " + sortedFiles);
		System.out.println("Files sorted by modification date: " + sortedFiles2);
	}
}
