package fr.upem.jacosa.io;
import java.io.*;

public class FileInverter
{
	public static final int BUFFER_SIZE = 1024;
	
	public static InputStream invertOrder(InputStream is) throws IOException
	{
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		is.transferTo(baos);
		byte[] content = baos.toByteArray();
		// Reverse the array
		for (int k = 0; k < content.length/2; k++)
		{
			byte tmp = content[k];
			content[k] = content[content.length - 1 - k];
			content[content.length - 1 - k] = tmp;
		}
		return new ByteArrayInputStream(content);
	}
	
	/** Invert data from the standard input and print it to the standard output */
	public static void main(String[] args) throws IOException
	{
		InputStream reversed = invertOrder(System.in);
		byte[] tab = new byte[BUFFER_SIZE];
		int r = 0;
		while ((r = reversed.read(tab)) > 0)
			System.out.write(tab, 0, r);
	}
}
