package fr.upem.jacosa.io;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;

public class FileCopier1
{
	public static final int BUFF_LEN = 1024;
	
	public static void transfer(InputStream is, OutputStream os) throws IOException
	{
		byte[] data = new byte[BUFF_LEN];
		for (int i = is.read(data); i >= 0; i = is.read(data))
			os.write(data, 0, i);
	}

	public static void copyFile(String source, String destination) throws IOException
	{
		try (
			InputStream is = 
				new BufferedInputStream(Files.newInputStream(Paths.get(source)));
			OutputStream os = 
				new BufferedOutputStream(Files.newOutputStream(Paths.get(destination)))
			)
		{
			transfer(is, os);
		}
	}
	
	public static void main(String[] args) throws IOException
	{
		if (args.length < 2) 
		{
			System.err.println("Usage: java FileCopier1 source destination");
			System.exit(-1);
		}
		copyFile(args[0], args[1]);
	}
}
