package fr.upem.jacosa.injection;

import com.google.inject.Guice;

public class HelloPrinterMain {
    public static void main(String[] args) {
        var params = new HelloPrinterParams(
                args.length >= 1 ? args[0] : "foobar", // name
                args.length >= 3 ? Integer.parseInt(args[1]) : 0, // minDisplayTimes
                args.length >= 3 ? Integer.parseInt(args[2]) : 100 // maxDisplayTimes
        );
        var injector = Guice.createInjector(new HelloPrinterInjectionModule(params));
        var hp = injector.getInstance(HelloPrinter.class);
        hp.sayHello();
    }
}
