package fr.upem.jacosa.injection;

import javax.inject.Inject;
import javax.inject.Named;
import java.util.Random;
import java.util.stream.IntStream;

public class HelloPrinter {
    @Inject
    @Named("name")
    private String name;

    private final MessageDisplayer displayer;

    private final Random random;

    private int displayMinTimes;

    private int displayMaxTimes;

    @Inject
    public HelloPrinter(@Named("stderr") MessageDisplayer displayer, Random random) {
        this.displayer = displayer;
        this.random = random;
    }

    @Inject
    public void setDisplayTimes(@Named("displayMinTimes") int displayMinTimes, @Named("displayMaxTimes") int displayMaxTimes) {
        this.displayMinTimes = displayMinTimes;
        this.displayMaxTimes = displayMaxTimes;
    }

    public void sayHello() {
        int i = random.nextInt(displayMinTimes, displayMaxTimes);
        IntStream.range(0, i).forEach(x -> {
            displayer.display(x + ": Hello World " + name);
        });
    }
}
