package fr.upem.jacosa.general;

import java.util.Objects;

class VerbosePerson
{
	private final String name;
	private final int birthYear;
	
	public VerbosePerson(String name, int birthYear)
	{
		this.name = name;
		this.birthYear = birthYear;
	}
	
	public String getFieldString()
	{
		return String.format("name=%s,birthYear=%d", name, birthYear);
	}
	
	@Override
	public final String toString()
	{
		return getClass().getSimpleName() + "[" + getFieldString() + "]";
	}
}
	
class VerboseStudent extends VerbosePerson
{
	private final String curriculum;
	
	public VerboseStudent(String name, int birthYear, String curriculum)
	{
		super(name, birthYear);
		this.curriculum = curriculum;
	}
	
	@Override
	public String getFieldString()
	{
		return String.format("%s,curriculum=%s", super.getFieldString(), curriculum);
	}
}

public class VerboseStudentTest 
{
	public static void main(String[] args)
	{
		VerbosePerson p = new VerbosePerson("Harry Cover", 2000);
		VerbosePerson p2 = new VerboseStudent("Jane Doe", 2001, "DUT2 info");
		System.out.println("p=" + p);
		System.out.println("p2=" + p2);
	}
}
