package fr.upem.jacosa.general;

import java.util.Objects;

class GenericPerson
{
	private final String name;
	private final int birthYear;
	
	public GenericPerson(String name, int birthYear)
	{
		this.name = name;
		this.birthYear = birthYear;
	}
	
	@Override
	public boolean equals(Object other)
	{
		if (this == other) return true; // pas la peine de se fatiguer plus longtemps si les références sont égales
		if (other == null) return false; // forcément this != null
		// le test qui suit garantit le respect de la symétrie en cas de descendance
		
		// if (! other instanceof Person) return false; // à éviter car cela brise la symétrie en cas d'héritage
		if (! getClass().equals(other.getClass())) return false; // les classes des deux objets doivent être identiques
		
		// si les classes des deux objets sont les mêmes, on est sûr de la symétrie : la méthode equals de this est la même que celle de other
		GenericPerson other2 = (GenericPerson)other; // cast nécessaire, aucun risque d'exception car on a préalablement testé l'égalité des classes
		return Objects.equals(name, other2.name) && birthYear == other2.birthYear; // on compare le contenu
	}
}
	
class Student extends GenericPerson
{
	private final String curriculum;
	
	public Student(String name, int birthYear, String curriculum)
	{
		super(name, birthYear);
		this.curriculum = curriculum;
	}
	
	@Override
	public boolean equals(Object other)
	{
		// Exploitons l'implantation de la classe ancêtre... et ajoutons la comparaison du curriculum
		return super.equals(other) && Objects.equals(curriculum, ((Student)other).curriculum);
	}
}

public class StudentTest
{
	public static void main(String[] args)
	{
		Person p = new Person("John Doe", 1995);
		Student s = new Student("John Doe", 1995, "DUT2info");
		System.out.println("p.equals(s) ? " + p.equals(s));
		System.out.println("s.equals(p) ? " + s.equals(p));
	}
}
