package fr.upem.jacosa.general;

import java.util.Arrays;

public class SheepCloning
{
	public interface Animal
	{
		public char[] getDNA();
	}
	
	public static class Sheep implements Animal
	{
		protected char[] dna;
		public char[] getDNA() { return dna; }
		
		public Sheep(String bases)
		{
			this.dna = bases.toCharArray();
		}
		
		@Override
		public String toString()
		{
			return getClass().getSimpleName() + "[dna=" + Arrays.toString(dna) + "]";
		}
	}
	
	public static class CloneableSheep extends Sheep implements Cloneable
	{
		public CloneableSheep(String bases)
		{
			super(bases);
		}
		
		public CloneableSheep shallowClone()
		{
			try {
				return (CloneableSheep)super.clone();
			} catch (CloneNotSupportedException e) {
				throw new RuntimeException(e);
			}
		}

		public CloneableSheep clone()
		{
			CloneableSheep sheep = shallowClone();
			sheep.dna = new char[this.dna.length];
			System.arraycopy(this.dna, 0, sheep.dna, 0, this.dna.length);
			return sheep;
		}
	}
	
	public static class Virus
	{
		public void attack(Animal animal)
		{
			char[] dna = animal.getDNA();
			for (int i = 0; i < dna.length; i+=2)
				dna[i] = 'A'; // replace all the pair bases with Adenosine
		}
	}
	
	public static void main(String[] args)
	{
		Sheep dolly = new CloneableSheep("ACGT");
		Sheep dolly2 = ((CloneableSheep)dolly).shallowClone();
		Sheep dolly3 = ((CloneableSheep)dolly).clone();
		
		System.out.println("Dolly before virus attack: " + dolly);
		System.out.println("Dolly2 before virus attack: " + dolly2);
		System.out.println("Dolly3 before virus attack: " + dolly3);
		
		Virus virus = new Virus(); // We create a nasty virus
		virus.attack(dolly2); // The virus modifies the shared DNA of dolly2 and dolly
		
		System.out.println("Dolly after virus attack: " + dolly);
		System.out.println("Dolly2 after virus attack: " + dolly2);
		System.out.println("Dolly3 after virus attack: " + dolly3);
	}
}