package fr.upem.jacosa.general;

import java.io.PrintStream;
import java.util.Arrays;

/** Implementation of the Eratosthenes's sieve to identify the first prime numbers */
public class PrimeSieve
{
	private final boolean[] primeStatus;
	
	public PrimeSieve(int n)
	{
		primeStatus = new boolean[n];
		Arrays.fill(primeStatus, true); // by default all the integers are prime... until being declared as a multiple by a sieve iteration
	}
	
	/** Mark integers that are multiple of k */
	public void mark(int k)
	{
		for (int i = 2*k; i < primeStatus.length; i += k)
			primeStatus[i] = false;
	}
	
	/** Do all the marking iterations */
	public void mark()
	{
		if (primeStatus.length >= 0) primeStatus[0] = false;
		if (primeStatus.length >= 1) primeStatus[1] = false;
		for (int i = 2; i * i < primeStatus.length; i++)
			if (primeStatus[i])
				mark(i);
	}
	
	public void printPrimes(PrintStream out)
	{
		for (int i = 0; i < primeStatus.length; i++)
			if (primeStatus[i])
				out.println(i);
	}
	
	public static void main(String[] args)
	{
		PrimeSieve ps = new PrimeSieve(Integer.parseInt(args[0]));
		ps.mark();
		ps.printPrimes(System.out);
	}
}
