package fr.upem.jacosa.general;

public class Prime
{

	public static boolean isPrime(int n)
	{
		if (n < 2) return false;
		if (n == 2) return true;
		if (n % 2 == 0) return false;
		int limit = (int)Math.sqrt((double)n);
		for (int i = 3; i <= limit; i += 2)
			if (n % i == 0) return false;
		return true;
	}

	public static int primesSmallerThan(int n)
	{
		int k = 0;
		if (n >= 2) k++;
		for (int i = 3; i <= n; i += 2)
			if (isPrime(i)) k++;
		return k;
	}

	public static void main(String[] args)
	{
		int n = (int)(System.currentTimeMillis() / 1000L / 60L);
		System.out.println(String.format("Number of primes <= %d: %d", n, primesSmallerThan(n)));
	}

}
