package fr.upem.jacosa.general;

// @run: IncTest

public class IncTest 
{
	// Voici une classe pour conserver une valeur
	
	public static class Box implements Cloneable 
	{ 
		public int field; // should implement getter/setter, just for testing
		
		/** Clone the current box */
		public Box clone()
		{
			try {
				return (Box)super.clone();
			} catch (CloneNotSupportedException e) {
				throw new RuntimeException(e);
			}
		}
	}

	// Écrivons différentes méthodes statiques d'incrémentation :

	/** Increment the given integer parameter
	 * This method has no outside effect since the value of the parameter is copied on the stack
	 * The new incremented value is then lost when we exit from the method 
	 */
	public static void inc1(int i)
	{
		i++;
	}

	/** We increment the field inside the Box object given as parameter
	 * We note that Box object reference is final (not its content)
	 */
	public static void inc2(final Box b)
	{
		b.field++;
	}

	/** We increment the first cell of the integer array passed as parameter */
	public static void inc3(final int[] a)
	{
		assert(a.length >= 1) ; // Check that the array contains at least one element
		a[0]++;
	}
	
	// Écrivons une méthode main pour tester ces différentes méthodes d'incrémentation :

	public static void main(String[] args)
	{
		final Box box = new Box(); // box.field == 0
		box.field = 1;
		inc1(box.field);
		System.out.println(box.field); // 1
		inc2(box);
		System.out.println(box.field); // 2
		final int[] array = new int[]{box.field};
		inc3(array);
		System.out.println(array[0]); // 3
		System.out.println(box.field); // 2
		inc2(box.clone());
		System.out.println(box.field); // 2
	}
}
