package fr.upem.jacosa.general;

import java.util.function.*;

// @run: FuncTest
public class FuncTest
{
	public static long mult(int x, int y)
	{
		return (long)x * (long)y;
	}

	public static <U, T, R> Function<U, R> compose(Function<U, T> f1, Function<T, R> f2)
	{
		return (x) -> f2.apply(f1.apply(x));
	}

	public static <U, V, R> Function<U,R> partialApply(BiFunction<U, V, R> bifunc, V arg2)
	{
		return arg -> bifunc.apply(arg, arg2);
	}

	public static Function<Long, Integer> logFunction(int base)
	{
		return compose(x -> (x > 0)?Long.toString(x, base):"", x -> x.length() - 1);
	}

	public static void main(String[] args)
	{
		Function<Integer, Long> mult2 = partialApply(FuncTest::mult, 2);
		System.out.println("Let's multiply 7 by 2: " + mult2.apply(7));

		Function<Long, Integer> log2 = logFunction(2);
		Function<Long, Integer> log10 = logFunction(10);
		long n = 1037L;
		System.out.println(String.format("Logs for %d: base2=%d, base10=%d", n, log2.apply(n), log10.apply(n)));
	}
}
