package fr.upem.jacosa.general;

interface TaxableItem
{
	/** Return the VAT rate of the item */
	public float getVATRate();
	
	/** Return the raw price (tax excluded) of the article */
	public int getRawPrice();
	
	/** Return the price with the tax included */
	public default int getTaxIncludedPrice() 
	{ 
		return (int)(getRawPrice() * (1.0f + getVATRate())); 
	}
}

interface Nameable
{
	public String getName();
}

class Food implements TaxableItem, Nameable
{
	public static final float FOOD_VAT_RATE = 0.055f; // rate in France
	
	private final String name;
	private final int rawPrice;
	
	public Food(String name, int rawPrice)
	{
		this.name = name;
		this.rawPrice = rawPrice;
	}
	
	@Override
	public String getName()
	{
		return this.name;
	}
	
	@Override
	public float getVATRate() 
	{
		return FOOD_VAT_RATE;
	}
	
	@Override
	public int getRawPrice()
	{
		return rawPrice;
	}
}

// @run: FoodTester
public class FoodTester
{
	public static void main(String[] args)
	{
		Food apple = new Food("apple", 1000);
		System.out.println("Price of " + apple + " (with tax): " + apple.getTaxIncludedPrice());
	}
}