package fr.upem.jacosa.general;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

// @run: FilteringArrayList
/** A list that does not add null values (we override the add method) */
public class FilteringArrayList<T> extends AbstractCollection<T>
{
	public interface Filter<T>
	{
		public boolean accept(T e) ;
	}
	
	private final ArrayList<T> list ;
	private final Filter<T> filter ; 
	
	public FilteringArrayList(Filter<T> filter)
	{
		list = new ArrayList<T>() ;
		this.filter = filter ;
	}

	public boolean add(T e)
	{
		if (filter.accept(e)) return list.add(e);
		else return false;
	}
	
	@Override
	public int size() { return list.size(); }
	
	@Override
	public Iterator<T> iterator() { return list.iterator(); }
	
	
	public static void main(String[] args)
	{
		// Instantiation of a list
		// not containing null references

		// Without lambda
		FilteringArrayList<Integer> l1 = new FilteringArrayList<Integer>(
			new Filter<Integer>()
			{
				public boolean accept(Integer e)
				{
					return e != null ;
				}
			}) ;
		l1.add(1);
		l1.add(2);
		l1.add(null);
		System.out.println("Size of l1: " + l1.size());

		// With lambda
		FilteringArrayList<Integer> l2 = 
			new FilteringArrayList<Integer>(e -> e != null) ;
		l2.add(1);
		l2.add(2);
		l2.add(null);
		System.out.println("Size of l2: " + l1.size());
	}
}