package fr.upem.jacosa.general;

import java.io.File;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

// @run: FileLister

/** List all the files of a directory (sorted by name and modification date) */
public class FileLister
{
	public static void main(String[] args)
	{
		final String dir = args[0];
		// we retrieve the directory listing into an array of files
		File[] files = new File(dir).listFiles();
		
		// we add the files into a SortedSet (the natural ordering on files is based on the lexicographic order of their names)
		SortedSet<File> sortedFiles = new TreeSet<>() ;
		for (File f: files) sortedFiles.add(f) ;
		
		// we use an other SortedSet with an explicit order based on the modification date of the file
		SortedSet<File> sortedFiles2 = new TreeSet<>( (f1, f2) -> Long.compare(f1.lastModified(), f2.lastModified()) ) ;
		for (File f : files) sortedFiles2.add(f) ;

		System.out.println("Files sorted by name: " + sortedFiles);
		System.out.println("Files sorted by modification date: " + sortedFiles2);
	}
}
