package fr.upem.jacosa.general;

/** A simple box containing an integer
 *  demonstrating the change of visibility of the method {@link Object#clone()},
 *  the change of the return type (covariance)
 *  and the capture of the exception possibly thrown (by transforming it into a {@link RuntimeException}).
 */
public class CloneableBox implements Cloneable
{
	private int value;
	
	public int getValue()
	{
		return value;
	}
	
	@Override
	public CloneableBox clone()
	{
		try {
			return (CloneableBox) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e); // never reached in fact
		}
	}
}
