package fr.upem.jacosa.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;

/** Computation of the median of a stream */
public class StreamMedian 
{
	/** We create a collector that fetches the median of a stream */
	public static <T> Collector<T, List<T>, T> medianCollector()
	{
		return Collector.of(() -> new ArrayList<T>(), // the supplier
			(list, element) -> { list.add(element); }, // the accumulator
			
			// the combiner
			(list1, list2) -> { 
				List<T> list3 = new ArrayList<T>(list1); 
				list3.addAll(list2); 
				return list3; },
			
			// the finisher
			(list) -> {
				list.sort(null);
				return list.get(list.size() / 2);
			});
	}
	
	public static <T> T computeMedian(Stream<T> stream)
	{
		return stream.collect(medianCollector());
	}
	
	/** We test in the main the computeMedian method */
	public static void main(String[] args)
	{
		String median = computeMedian(Arrays.asList(args).stream());
		System.out.println("Median of the arguments: " + median);
	}
}
