package fr.upem.jacosa.collections;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class DuplicateRemoverTest
{
	public static final int LIST_SIZE = 10000;
	public static final int MAX_NUMBER = 20;
	
	private static Random random = null;
	private List<Integer> list = null;
	
	@BeforeAll
	public static void initClass()
	{
		random = new Random();
	}
	
	@BeforeEach
	public void initList()
	{
		list = new ArrayList<Integer>();
		for (int i = 0; i < LIST_SIZE; i++)
			list.add(random.nextInt(MAX_NUMBER));
		Collections.sort(list);
	}
	
	@Test
	public void testDuplicateRemover()
	{
		Assertions.assertTrue(DuplicateRemover.isSorted(list), "The list is not sorted");
		int initialSize = list.size();
		int duplicateNumber = DuplicateRemover.getDuplicateNumber(list);
		DuplicateRemover.removeDuplicates(list);
		Assertions.assertTrue(initialSize == list.size() + duplicateNumber, "The number of elements is incorrect");
		Assertions.assertTrue(DuplicateRemover.isSorted(list), "The list is not sorted");
	}
	
	@Test
	public void testDuplicateRemover2()
	{
		TreeSet<Integer> set = new TreeSet<>(list);
		DuplicateRemover.removeDuplicates(list);
		Iterator<Integer> setIterator = set.iterator();
		Iterator<Integer> listIterator = list.iterator();
		while (setIterator.hasNext())
		{
			Assertions.assertTrue(listIterator.hasNext());
			Integer a = setIterator.next();
			Integer b = listIterator.next();
			Assertions.assertEquals(a, b);
		}
		Assertions.assertFalse(listIterator.hasNext());
	}

}
