package fr.upem.jacosa.areacomputation;


import java.util.function.Predicate;

/** Test the area computer */
public class AreaComputerTester
{
	public static void main(String[] args)
	{
		final double squareSide = 1000.0;

		// we use an anonymous class to define the first circle
		var circle = new Shape()
		{
			@Override
			public boolean isInside(Point p)
			{
				return p.getDistanceFromTheOrigin() <= squareSide;
			}
		};

		// we use a lambda expression for the second circle (more concise)
		Predicate<Point> circle2 = p -> p.getDistanceFromTheOrigin() <= squareSide;

		// again a lambda expression
		Predicate<Point> semiSquare = p -> p.getX() <= 500.0 && p.getY() <= 500.0;

		final AreaComputer ac = new AreaComputer(squareSide, circle2);
		int throwNumber = 1;
		long start = System.nanoTime(); // return the current time in nanoseconds
		// multiply by 10 the number of throws for each turn
		for (int i = 0; i <= 9; i++)
		{
			// the estimated surface must become more accurate as we increase the number of throws
			final var estimatedSurface = ac.estimateSurface(throwNumber);
			System.out.println("Estimated surface after " + throwNumber + " throws: " + estimatedSurface);
			throwNumber *= 10;
		}
		// estimate the time used to compute the surfaces
		System.err.println("Time used in seconds: " + (double)(System.nanoTime() - start) / 1e9 );
	}
}
