package fr.upem.jacosa.annotations;

import com.google.inject.Inject;
import com.google.inject.name.Named;

/** A simple customer for an online shop */
public class Customer
{
	@Inject @Named("customerName")
	private String name = null;
	
	@Inject @Named("customerAddress")
	private String address = null;
	
	@Inject
	private ShoppingBasket basket;
	
	public String getName()
	{
		return name;
	}
	
	public String getAddress()
	{
		return address;
	}
	
	public ShoppingBasket getBasket()
	{
		return basket;
	}
	
	@Override
	public String toString()
	{
		return "Customer[" + name + "@" + address + "]";
	}
}
