package fr.upem.jacosa.annotations;

public class Contact
{
	@StringConstraint(nullable=false, minLength=1)
	private final String name;
	
	public Contact(String name)
	{
		ConstraintChecker.checkConstraints(getClass(), "name", name);
		this.name = name;
	}
	
	@StringConstraint(nullable=false, regex="[0-9]*", minLength=10)
	private String phoneNumber;
	
	public void setPhoneNumber(String phoneNumber)
	{
		ConstraintChecker.checkConstraints(getClass(), "phoneNumber", phoneNumber);
		this.phoneNumber = phoneNumber;
	}
}
