package fr.upem.jacosa.annotations;

import java.lang.reflect.Field;
import java.util.regex.Pattern;

public class ConstraintChecker
{
	public static void checkConstraints(Field field, Object value)
	{
		StringConstraint sc = field.getAnnotation(StringConstraint.class);
		if (sc != null)
		{
			if (value == null && ! sc.nullable()) 
				throw new ConstraintViolation("nullability constraint not respected");
			if (value != null)
			{
				String stringValue = value.toString();
				if (stringValue.length() < sc.minLength())
					throw new ConstraintViolation("minimum length not respected with " + value);
				if (stringValue.length() > sc.maxLength())
					throw new ConstraintViolation("maximum length not respected with " + value);
				if (! Pattern.matches(sc.regex(), stringValue))
					throw new ConstraintViolation(stringValue + " does not match the regexp " + sc.regex());
			}
		}
	}
	
	/** Calling this method raise an exception if there is a constraint violation */
	public static void checkConstraints(Class<?> klass, String fieldName, Object value)
	{
		try {
			checkConstraints(klass.getField(fieldName), value);
		} catch (NoSuchFieldException | SecurityException e) {
			throw new RuntimeException(e); // transform to an unchecked exception
		}
	}
}
