import { Component, OnInit, OnDestroy } from '@angular/core';
import { TimestampService } from '../timestamp.service';

@Component({
  selector: 'app-timestamp',
  template: `<div>Timestamp: {{ timestamp }}`
})
export class TimestampComponent implements OnInit, OnDestroy {
  
  timestamp = -1;
  subscription: any = null;

  constructor(private timestampService: TimestampService) { }

  ngOnInit() {
    let that = this; // to have a reference to the component
	this.subscription = this.timestampService.subscribe({
		next(timestamp) { that.timestamp = timestamp; },
		error(msg) { /* not used yet */ },
		complete(msg) { /* not used yet */ }
	});
  }
  
  ngOnDestroy() {
    if (this.subscription)
		this.subscription.unsubscribe();
  }

}
