import { Component, Input, Output, EventEmitter } from '@angular/core';

@Component({
  selector: 'app-slot-machine',
  template: `<div *ngIf="draw !== null">Slot machine draw: {{ draw[0] }} - {{ draw[1] }}</div>
			 <div *ngIf="draw === null">Slot machine not used yet</div>`
})
export class SlotMachineComponent  {
  readonly minSymbol = 1;
  readonly maxSymbol = 7;
  readonly betMultiplier = 7; // the bet is multiplied by this value when we win
  
  // money bet in the slot machine
  @Input() bet: number;
  
  draw: [number, number] | null = null;
  
  @Output() gain = new EventEmitter<number>();
  
  randomInt() { return Math.floor(Math.random() * (this.maxSymbol - this.minSymbol) + 1) + this.minSymbol; }
  
  doNewDraw() {
	this.draw = [this.randomInt(), this.randomInt()];
	if (this.draw[0] === this.draw[1])
		this.gain.emit( this.bet * this.betMultiplier ); // we win and multiply the bet
	else
		this.gain.emit ( - this.bet ); // we lose the bet
  }
}
