import { Component, OnInit, Input } from '@angular/core';
import { PictureFetcherService } from '../picture-fetcher.service';
import { Router, ActivatedRoute, ParamMap } from '@angular/router';

@Component({
  selector: 'app-picture-viewer',
  template: `<img *ngIf="imageDataURL" [src]="imageDataURL" (click)="loadNewImage()"> 
	<button *ngIf="! imageDataURL" (click)="loadNewImage()">Load image</button>`
})
export class PictureViewerComponent implements OnInit {
  
  @Input() width: number;
  @Input() height: number;
  
  imageDataURL: string|null;

  constructor(private pictureFetcher: PictureFetcherService,
	private route: ActivatedRoute,
	private router: Router) { }

  ngOnInit() {
    let paramMap = this.route.snapshot.paramMap;
    let [w, h] = [paramMap.get('width'), paramMap.get('height')];
    if (typeof(w)==="string")
		this.width = +w;
	  if (typeof(h)==="string")
		  this.height = +h;
  }

  loadNewImage() {
	this.pictureFetcher.getPictureDataURLObservable(this.width, this.height).subscribe(
		(dataURL) => { this.imageDataURL = dataURL; }
	);
  }
}
