import { Component, Input, ChangeDetectionStrategy } from '@angular/core';
import { Person } from "../model/person"

@Component({
  selector: 'app-person',
  template: `<div>Component ID: {{ id }}, FirstName: {{ person.firstName }}, LastName: {{ person.lastName }}</div>`,
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class PersonComponent {
  @Input() person: Person;

  /** Giving an unique incrementing id for each component */
  static counter = 0;
  id = PersonComponent.counter++;

  constructor() { }
}

