import { Component, OnInit, OnDestroy } from '@angular/core';
import { shuffle } from '../utils/arrays';

@Component({
  selector: 'app-mutability',
  template: `<div>
	<p>Calling method getCurrentDate(): {{ getCurrentDate() | date:'fullTime' }}</p>
	<p>Displaying now field: {{ now | date:'fullTime' }}</p>
	<p>Content of the array (shuffled each second): {{ shuffledArray }}</p>
	<p>Content of a copy of the array: {{ copiedShuffledArray }}</p> 		
  </div>`,
  styleUrls: ['./mutability.component.css']
})
export class MutabilityComponent implements OnInit, OnDestroy {
  now: Date;
  shuffledArray = [1, 2, 3, 4, 5, 6];
  copiedShuffledArray: number[];
  intervalHandle;

  constructor() {
	this.now = this.getCurrentDate();
  }

  getCurrentDate(): Date {
	return new Date();
  }

  ngOnInit() {
	this.intervalHandle = setInterval(() => {
		this.now = this.getCurrentDate();
		shuffle(this.shuffledArray);
		this.copiedShuffledArray = this.shuffledArray.slice(0, this.shuffledArray.length);
	}, 1000);
  }

  ngOnDestroy() {
	if (this.intervalHandle)
		clearInterval(this.intervalHandle);
  }
}
