import { Component, EventEmitter, Input, Output } from '@angular/core';

import { shuffle } from '../utils/arrays';

@Component({
  selector: 'app-keypad',
  template: `<div>
	<table>
		<tr *ngFor="let i of [0, 3, 6]">
			<td *ngFor="let j of [i, i+1, i+2]">
				<button (click)="appendDigit(this.digits[j])">{{ this.digits[j] }}</button>
			</td>
		</tr>
	</table>
	{{ value }}
  </div>
  `
})
export class KeypadComponent {
  readonly digits = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
  
  @Input() value: string = "";
  @Output() valueChange = new EventEmitter<string>();
  
  constructor() { 
	shuffle(this.digits);
  }

  appendDigit(j) {
	this.value += "" + j;
	this.valueChange.emit(this.value);
  }
}
