import { Component } from '@angular/core';

@Component({
  selector: 'app-divmove',
  template: `<div>
	<div class="divzone" (mousemove)="updateCoordinates($event)"></div>
	<ul *ngIf="x !== null && y !== null">
		<li>x = {{ x }}</li>
		<li>y = {{ y }}</li> 
	</ul>
	<div *ngIf="x === null">
		Not already entered in the red div zone!
	</div>
  `,
  styles: [`.divzone { width: 300px; height: 300px; background-color: red }`]
})
export class DivmoveComponent {

  x: number|null = null;
  y: number|null = null;

  updateCoordinates(event) {
	[this.x, this.y] = [event.offsetX, event.offsetY];
  }
}
